
describe('IMI library Convert 動作確認', function() {

	it('MappingとデータからRDF/XMLへ変換', function() {
	var m = new IMIToolsCore.Mapping({
	"mapping": {
		"NO": "ic:施設型>ic:ID>ic:識別値",
		"名称": "ic:施設型>ic:名称>ic:表記",
		"名称_カナ": "ic:施設型>ic:名称>ic:カナ表記",
		"住所": "ic:施設型>ic:住所>ic:表記",
		"方書": "ic:施設型>ic:住所>ic:方書",
		"緯度": "ic:施設型>ic:地理座標>ic:緯度",
		"経度": "ic:施設型>ic:地理座標>ic:経度",
		"標高": "ic:施設型>ic:地理座標>ic:測地高度>ic:数値",
		"電話番号": "ic:施設型>ic:連絡先>ic:電話番号",
		"内線番号": "ic:施設型>ic:連絡先>ic:内線番号",
		"市区町村コード": "ic:施設型>ic:関与{ic:役割='設置主体'}>ic:関与者{@ic:組織型}>ic:ID>ic:識別値",
		"都道府県名": "ic:施設型>ic:関与{ic:役割='設置主体'}>ic:関与者{@ic:組織型}>ic:住所>ic:都道府県",
		"市区町村名": "ic:施設型>ic:関与{ic:役割='設置主体'}>ic:関与者{@ic:組織型}>ic:住所>ic:市区町村",
		"洪水": "ic:施設型>ic:種別コード[災害種別_洪水]>ic:識別値",
		"土砂災害": "ic:施設型>ic:種別コード[災害種別_崖崩れ、土石流及び地滑り]>ic:識別値",
		"高潮": "ic:施設型>ic:種別コード[災害種別_高潮]>ic:識別値",
		"地震": "ic:施設型>ic:種別コード[災害種別_地震]>ic:識別値",
		"津波": "ic:施設型>ic:種別コード[災害種別_津波]>ic:識別値",
		"大規模な火事": "ic:施設型>ic:種別コード[災害種別_大規模な火事]>ic:識別値",
		"内水氾濫": "ic:施設型>ic:種別コード[災害種別_内水氾濫]>ic:識別値",
		"火山現象": "ic:施設型>ic:種別コード[災害種別_火山現象]>ic:識別値",
		"指定避難所との重複": "ic:施設型>ic:種別コード[指定避難所との重複]>ic:識別値",
		"収容人数": "ic:施設型>ic:記述{ic:種別='想定収容人数'}>ic:説明",
		"対象となる町会・自治会": "ic:施設型>ic:関与{ic:役割='対象となる町会・自治会'}>ic:関与者{@ic:組織型}>ic:名称>ic:表記",
		"URL": "ic:施設型>ic:参照>ic:参照先",
		"備考": "ic:施設型>ic:備考"
	},
	}, ic);
	
	var c = new IMIToolsCore.Converter(m);

	/* CSV to JSON */
	var CSV = 
"NO,名称,名称_カナ,住所,方書,緯度,経度,標高,電話番号,内線番号,市区町村コード,都道府県名,市区町村名,洪水,土砂災害,高潮,地震,津波,大規模な火事,内水氾濫,火山現象,指定避難所との重複,収容人数,対象となる町会・自治会,URL,備考\n" +
"001,共通語彙基盤,キョウツウゴイキバン,東京都文京区本駒込二丁目28番8号 文京グリーンコートセンターオフィス16階,総合受付13階,34.562,145.26,12.5,03-5978-7501,2613,13105,東京都,文京区駒込二丁目,X,Y,Z,●,×,△,■,＃,あり,256,IKC,https://www.ipa.go.jp/,IMI\n"
;
	var header = [];
	var jsonwork = [];

	CSV.split("\n").filter(function (a) {
	  return a.length > 0;
	}).map(function (a) {
	  return a.split(",");
	}).forEach(function (a, i) {

	  if (i === 0) {
	    header = a;
	    return;
	  }
	  var obj = {};
	  a.forEach(function (b, i) {
	    obj[header[i]] = b;
	  });
	  jsonwork.push(obj);
	});

/* DEBUG  class property set */
console.log(c.mapping.vocabulary.tree);

	var text = c.convert(jsonwork);
/*
	var text = c.convert([
{		"NO": "001",
		"名称": "共通語彙基盤",
		"名称_カナ": "キョウツウゴイキバン",
		"住所": "東京都文京区本駒込二丁目28番8号 文京グリーンコートセンターオフィス16階",
		"方書": "総合受付13階",
		"緯度": "34.562",
		"経度": "145.26",
		"標高": "12.5",
		"電話番号": "03-5978-7501",
		"内線番号": "2613",
		"市区町村コード": "13105",
		"都道府県名": "東京都",
		"市区町村名": "文京区駒込二丁目",
		"洪水": "X",
		"土砂災害": "Y",
		"高潮": "Z",
		"地震": "●",
		"津波": "×",
		"大規模な火事": "△",
		"内水氾濫": "■",
		"火山現象": "＃",
		"指定避難所との重複": "あり",
		"収容人数": "256",
		"対象となる町会・自治会": "IKC",
		"URL": "https://www.ipa.go.jp/",
		"備考": "IMI"
}
	]);
*/
	
	// データ変換表示
	var div_element = document.createElement("pre");
	var parent_object = document.getElementById("result");

	/*  
	マッピングファイル メッセージ
	*/
	var log_msg = JSON.stringify(m.validate(IMIToolsCore.Mapping.LEVEL_ALL));

	IMILib2017Common.Util.jsonld2rdf(text).then(function(result){
		div_element.innerText = log_msg.replace(/},{/g,"},\n{") + 
		"\n\n" + result.replace(/></g,">\n<");
		parent_object.appendChild(div_element);
	});

/* DEBUG generate mapping from structure dataset */
console.log(IMIToolsCore.Util.jsonld2mapping(text));

	return;

    }); 

  });

